

clear all ; close all ; clc

% note: this program takes a few hours to run on my laptop

%%%%%%%%%%%%%%%%%%%
% Forward-Looking %
%%%%%%%%%%%%%%%%%%%

optpol_forwardlookingZZ ;

STORECOM_FL_PARAM = [] ;
STORECOMP_FL_OPTPOL = [] ;
STORECOMP_FL_TAYLOR = [] ;
STORECOMP_FL_NAIVE = [] ;

for uvuxx=1:5
    eval(strcat('load ',strcat(' finalresFLXs_',num2str(uvuxx)))) ;
    STORECOMP_FL_OPTPOL(:,uvuxx) = TableShow(:,1) ;
    STORECOMP_FL_TAYLOR(:,uvuxx) = TableShow(:,4) ;
    STORECOMP_FL_NAIVE(:,uvuxx) = TableShow(:,5) ;
    STORECOMP_FL_PARAM(:,uvuxx) = [sigma,kappa,rho0*400,rho_end*400,400*std_epsX,400*std_uX,ac_eps,ac_u,16*lambda,beta] ;
end

% what to show: which comp statics
show_comstaticsFL = [1,2,3,4,5];
show_paramsFL = [3,4,5] ;
show_statisticsFL = [1,2,3,7,5,8,9,12] ;

fmt = ' %6.2f ' ;
names_paramFL = {'sigma','kappa','rho0','rho_end','\sigma(epsilon)','\sigma(u)','ac(eps)','ac(u)','lambda','\beta'};
names_statsFL = {'Loss';'Mean time to liftoff';'Median time to liftoff'; 'Mean x at liftoff' ; 'Median x at liftoff' ; 'Mean pi at liftoff';'Median pi at liftoff'; 'p75 of max pi'; 'p25 of min x';'Prob of neg nat rate after liftoff';'mean STD Delta i';'median STD Delta i';'mean STD i';'median STD i'} ;
rowFL = {'1';'2';'3';'4';'5';'6';'7'} ;
% param values
texprint(STORECOMP_FL_PARAM(show_paramsFL,show_comstaticsFL),fmt,rowFL(show_comstaticsFL),names_paramFL(show_paramsFL))
% outcomes w different policies
texprint(STORECOMP_FL_OPTPOL(show_statisticsFL,show_comstaticsFL),fmt,rowFL(show_comstaticsFL),names_statsFL(show_statisticsFL))
texprint(STORECOMP_FL_NAIVE(show_statisticsFL,show_comstaticsFL),fmt,rowFL(show_comstaticsFL),names_statsFL(show_statisticsFL))
texprint(STORECOMP_FL_TAYLOR(show_statisticsFL,show_comstaticsFL),fmt,rowFL(show_comstaticsFL),names_statsFL(show_statisticsFL))


%%%%%%%%%%%%%%%%%%%%
% Backward-looking %
%%%%%%%%%%%%%%%%%%%%

optpol_backwardlookingZZ ;

STORECOM_BL_PARAM = [] ;
STORECOMP_BL_OPTPOL = [] ;
STORECOMP_BL_TAYLOR = [] ;
STORECOMP_BL_NAIVE = [] ;

for uvu=1:10
    eval(strcat('load ',strcat(' finalresBLXs_',num2str(uvu)))) ;
    STORECOMP_BL_OPTPOL(:,uvu) = TableShow(:,1) ;
    STORECOMP_BL_TAYLOR(:,uvu) = TableShow(:,4) ;
    STORECOMP_BL_NAIVE(:,uvu) = TableShow(:,5) ;
    STORECOMP_BL_PARAM(:,uvu) = [sigma,kappa,delta,ksi,rho0*400,rho_end*400,400*std_epsX,400*std_uX,ac_eps,ac_u,16*lambda,beta,100*x0,400*pi0] ;
end



% what to show: which comp statics
show_comstaticsBL = [1,2,3,4,5,6,7,8,9,10];
show_paramsBL = [3,4,5,7,13,14] ;
show_statisticsBL = [1,2,3,7,5,8,9,12] ;

fmt = ' %6.2f ' ;
rowBL = {'1';'2';'3';'4';'5';'6';'7';'8';'9';'10'} ;
names_paramBL = {'sigma','kappa','\delta','\ksi','rho0','rho_end','\sigma(epsilon)','\sigma(u)','ac(eps)','ac(u)','lambda','\beta','x0','pi0'};
names_statsBL = {'Loss';'Mean time to liftoff';'Median time to liftoff'; 'Mean x at liftoff' ; 'Median x at liftoff' ; 'Mean pi at liftoff';'Median pi at liftoff'; 'p75 of max pi'; 'p25 of min x';'Prob of neg nat rate after liftoff';'mean STD Delta i';'median STD Delta i';'mean STD i';'median STD i'} ; 

% param values
texprint(STORECOMP_BL_PARAM(show_paramsBL,show_comstaticsBL),fmt,rowBL(show_comstaticsBL),names_paramBL(show_paramsBL))
% outcomes w different policies
texprint(STORECOMP_BL_OPTPOL(show_statisticsBL,show_comstaticsBL),fmt,rowBL(show_comstaticsBL),names_statsBL(show_statisticsBL))
texprint(STORECOMP_BL_NAIVE(show_statisticsBL,show_comstaticsBL),fmt,rowBL(show_comstaticsBL),names_statsBL(show_statisticsBL))
texprint(STORECOMP_BL_TAYLOR(show_statisticsBL,show_comstaticsBL),fmt,rowBL(show_comstaticsBL),names_statsBL(show_statisticsBL))

